#delimit;
clear;

set memory 400m;

log using unemp4050.log, replace;

use c:\data\census\hoursocc4050.dta;

drop if relate==13;

gen employed = empstat==1;
gen unemployed = empstat==2;
gen noninlf = empstat==3;

gen inlf = (empstat==1 | empstat==2);

gen agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

gen military=occ1950==595;
gen civilian = 1- military;

summ unemployed [w=perwt] if inlf==1 & year==94;
summ unemployed [w=perwt] if inlf==1 & year==95;

table year agecat sex [w=perwt] if inlf==1 & military==0, c(mean unemployed);

log close;
