#delimit;
clear;

set memory 400m;

log using schoolcensus.log, replace;


use c:\data\census\empschool190030.dta;

drop if relate==13;

/* NOTE THAT THE LABOR FORCE VARIABLE IS ONLY ASKED FOR THOSE 16+ IN 1900-30
I THUS USE GAINFUL WORKERS FOR 14-15 YEAR OLDS.  FOR 15-16 YEAR OLDS, GAINFUL 
WORKER AND IN THE LABOR FORCE RATIOS ARE ALMOST IDENTICAL, SO I AM VERY 
CONFIDENT OF THE SUBSTITUION */

gen inschool = school==2;
gen inschoolb = occ1950==983;
gen inschoolc = inschool==1 & occ1950>=980;

gen inlf = labforce==2;
gen gainful = occ1950<980;

replace inlf = gainful if age<16;


table year [w=perwt] if age>=14 & age<18, 
  c(mean inlf mean inschool mean inschoolc);
table year [w=perwt] if age>=14 & age<18 & sex==1,
  c(mean inlf mean inschool mean inschoolc);
table year [w=perwt] if age>=14 & age<18 & sex==2,
  c(mean inlf mean inschool mean inschoolc);

table year [w=perwt] if age>=18 & age<25, 
  c(mean inlf mean inschool mean inschoolc);
table year [w=perwt] if age>=18 & age<25 & sex==1,
  c(mean inlf mean inschool mean inschoolc);
table year [w=perwt] if age>=18 & age<25 & sex==2,
  c(mean inlf mean inschool mean inschoolc);

gen stayhome = inschool==0 & occ1950>=980 & occ1950<=982;

table year [w=perwt] if age>=14 & age<18 & sex==2, c(mean stayhome);

clear;

use c:\data\census\school194060.dta;

drop if relate==13;

gen inschool = school==2;
gen inschoolc = inschool==1 & occ1950>=980;

gen inlf = labforce==2;
gen gainful = occ1950<980;

replace inlf = gainful if age<16;


table year [w=perwt] if age>=14 & age<18, c(mean inlf mean inschool 
  mean inschoolc);
table year [w=perwt] if age>=14 & age<18 & sex==1, c(mean inlf mean inschool
  mean inschoolc);
table year [w=perwt] if age>=14 & age<18 & sex==2, c(mean inlf mean inschool
  mean inschoolc);

summ inschool inschoolc [w=slwt] if age>=14 & age<18 & year==95;
summ inschool inschoolc [w=slwt] if age>=14 & age<18 & sex==1 & year==95;
summ inschool inschoolc [w=slwt] if age>=14 & age<18 & sex==2 & year==95;

table year [w=perwt] if age>=18 & age<25, c(mean inlf mean inschool
  mean inschoolc);
table year [w=perwt] if age>=18 & age<25 & sex==1, c(mean inlf mean inschool
  mean inschoolc);
table year [w=perwt] if age>=18 & age<25 & sex==2, c(mean inlf mean inschool
  mean inschoolc);

summ inschool inschoolc [w=slwt] if age>=18 & age<25 & year==95;
summ inschool inschoolc [w=slwt] if age>=18 & age<25 & sex==1 & year==95;
summ inschool inschoolc [w=slwt] if age>=18 & age<25 & sex==2 & year==95;

log close;

