#delimit;
clear;

set memory 400m;

log using hrs6207.log, replace;

/* USE CPS CIVLIAN DATA AND ADJUST FOR SEASONALITY OF STUDENT EMPLOYMENT

AGECAT 1:  14-17
AGECAT 2:  18-24
AGECAT 3:  25-34
AGECAT 4:  35-44
AGECAT 5:  45-54
AGECAT 6:  55-64
AGECAT 7:  65+

pop = sum(wgt), by(year sex agecat)
wkr = sum(wgt) if lfs=="e" & age>=16, by(year sex agecat)
tothrs = sum(hrswork*wgt), by(year)
hrs = sum(hrswork*wgt), by(year sex agecat)
hrspop = hrs/pop
hrswkr = hrs/wkr
hrscat = hrs/tothrs*100
*/

use mcpshrs5.dta;

/* ADJUST FOR FACT THAT CENSUS IS IN MAR-APRIL & TEEN EMPLOYMENT GOES UP
IN SUMMER.  USE RATIO OF ANNUAL TO MARCH FOR TEENS RELATIVE TO ANNUAL TO MARCH
FOR EVERYONE 16+.  Acc. to monthly CPS from 1977 on, no difference for
all 16+, but for 16-17, annual hours*emp is 30 percent higher than March for
males and 26 per cent for females.  For 18-24, it's 6 percent for males
and 4 percent for female. */

gen hrswork = hrs;
replace hrswork = 1.30*hrs if sex==1 & agecat==1;
replace hrswork = 1.26*hrs if sex==2 & agecat==1;
replace hrswork = 1.06*hrs if sex==1 & agecat==2;
replace hrswork = 1.04*hrs if sex==2 & agecat==2;

by year: egen tothrswork = sum(hrswork);

*sort year sex agecat;

* NOTE: For Civilian only;

gen frhr = hrswork/tothrswork;

table year agecat sex, c(mean frhr);

log close;

