#delimit;
clear;

set memory 400m;

log using hrs6070.log, replace;

use c:\data\census\hoursocc6070.dta;

drop if relate==13;
drop if year==98;

*drop wkswork1 wkswork2 race;

gen agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

sort year sex agecat hrswork2 ;

*THESE ARE DATA FOR CALCULATING MEANS FOR INTERVALLED DATA;

merge year sex agecat hrswork2 using interval50.dta;
tab _merge; drop _merge;

sort year sex agecat hrswork2 ;

merge year sex agecat hrswork2 using interval80.dta;
tab _merge; drop _merge;


*These intervaled numbers are based on my computations for overlap;

gen hrswork = interval50*(hrswork2==1) + interval50*(hrswork2==2)
  + interval50*(hrswork2==3) + interval50*(hrswork2==4)
  + interval50*(hrswork2==5) + interval50*(hrswork2==6)
  + interval50*(hrswork2==7) + interval50*(hrswork2==8) if year==96;

replace hrswork = interval80*(hrswork2==1) + interval80*(hrswork2==2)
  + interval80*(hrswork2==3) + interval80*(hrswork2==4)
  + interval80*(hrswork2==5) + interval80*(hrswork2==6)
  + interval80*(hrswork2==7) + interval80*(hrswork2==8) if year==97;

replace hrswork = 0 if hrswork==.;

/* ADJUST FOR FACT THAT CENSUS IS IN MAR-APRIL & TEEN EMPLOYMENT GOES UP
IN SUMMER.  USE RATIO OF ANNUAL TO MARCH FOR TEENS RELATIVE TO ANNUAL TO MARCH
FOR EVERYONE 16+.  Acc. to monthly CPS from 1977 on, no difference for
all 16+, but for 16-17, annual hours*emp is 30 percent higher than March for
males and 26 per cent for females.  For 18-24, it's 6 percent for males
and 4 percent for female. */

replace hrswork = 1.30*hrswork if sex==1 & agecat==0;
replace hrswork = 1.26*hrswork if sex==2 & agecat==0;
replace hrswork = 1.06*hrswork if sex==1 & agecat==1;
replace hrswork = 1.04*hrswork if sex==2 & agecat==1;

gen employed = empstat==1;

gen military = occ1950==595;
gen civilian = 1 - military;

gen unemployed = empstat==2;
gen noninlf = empstat==3;

gen hrsworkciv = 0; replace hrsworkciv = hrswork if military==0;

summ hrsworkciv [w=perwt] if year==96; gen sumhrsworkciv = r(sum) if year==96;

gen hrscivfr = hrsworkciv/sumhrsworkciv;

table sex agecat [w=perwt] if year==96, c(sum hrscivfr) row;

log close;

