#delimit;
clear;

set memory 400m;

log using empteen0030.log, replace;

*  DERIVING FRACTIONS FOR PARSING TOTAL HOURS BY GROUP;

use c:\data\census\empschool190030.dta;

drop if relate==13;

/* NOTE THAT THE LABOR FORCE VARIABLE IS ONLY ASKED FOR THOSE 16+ IN 1900-30
I THUS USE GAINFUL WORKERS FOR 14-15 YEAR OLDS.  FOR 15-16 YEAR OLDS, GAINFUL 
WORKER AND IN THE LABOR FORCE RATIOS ARE ALMOST IDENTICAL, SO I AM VERY 
CONFIDENT OF THE SUBSTITUION */



gen inschool = school==2;

gen agecat = -4 if age>=10 & age<14 & inschool==1;
replace agecat = -3 if age>=10 & age<14 & inschool==0;
replace agecat = -2 if age>=14 & age<18 & inschool==1;
replace agecat = -1 if age>=14 & age<18 & inschool==0;
replace agecat = 0 if age>=18 & age<25 & inschool==1;
replace agecat = 1 if age>=18 & age<25 & inschool==0;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

*THESE UNEMPLOYMENT RATES WERE CALCULATED FROM EMPSTAT VARIABLE IN 1910;

gen unempciv = 0.0217305 if sex== 1 & agecat== -4;
replace unempciv = 0.0298605 if sex== 1 & agecat== -3;
replace unempciv = 0.0292757 if sex== 1 & agecat== -2;
replace unempciv = 0.0406258 if sex== 1 & agecat== -1;
replace unempciv = 0.0432268 if sex== 1 & agecat== 0;
replace unempciv = 0.045374 if sex== 1 & agecat== 1;
replace unempciv = 0.0498483 if sex== 1 & agecat== 2;
replace unempciv = 0.0504271 if sex== 1 & agecat== 3;
replace unempciv = 0.0425217 if sex== 1 & agecat== 4;
replace unempciv = 0.063405 if sex== 1 & agecat== 5;
replace unempciv = 0.1047295 if sex== 1 & agecat== 6;
replace unempciv = 0.0396488 if sex== 2 & agecat== -4;
replace unempciv = 0.0294962 if sex== 2 & agecat== -3;
replace unempciv = 0.0423276 if sex== 2 & agecat== -2;
replace unempciv = 0.0416107 if sex== 2 & agecat== -1;
replace unempciv = 0.0603681 if sex== 2 & agecat== 0;
replace unempciv = 0.0440633 if sex== 2 & agecat== 1;
replace unempciv = 0.0498068 if sex== 2 & agecat== 2;
replace unempciv = 0.0466647 if sex== 2 & agecat== 3;
replace unempciv = 0.0415788 if sex== 2 & agecat== 4;
replace unempciv = 0.040985 if sex== 2 & agecat== 5;
replace unempciv = 0.0585256 if sex== 2 & agecat== 6;

gen unemp = 0.0217303 if sex==1 & agecat==-4;
replace unemp =  0.0298605 if sex==1 & agecat==-3;
replace unemp =  0.0292614 if sex==1 & agecat==-2;
replace unemp =  0.0405808 if sex==1 & agecat==-1;
replace unemp =  0.0429261 if sex==1 & agecat==-0;
replace unemp =  0.0449412 if sex==1 & agecat==1;
replace unemp =  0.0495997 if sex==1 & agecat==2;
replace unemp =  0.0503231 if sex==1 & agecat==3;
replace unemp =  0.0424881 if sex==1 & agecat==4;
replace unemp =  0.063371 if sex==1 & agecat==5;
replace unemp =  0.1046966 if sex==1 & agecat==6;
replace unemp =  0.0396488 if sex==2 & agecat==-4;
replace unemp =  0.0294962 if sex==2 & agecat==-3;
replace unemp =  0.0423276 if sex==2 & agecat==-2;
replace unemp =  0.0416107 if sex==2 & agecat==-1;
replace unemp =  0.0603681 if sex==2 & agecat==-0;
replace unemp =  0.0440633 if sex==2 & agecat==1;
replace unemp =  0.0498047 if sex==2 & agecat==2;
replace unemp =  0.0466647 if sex==2 & agecat==3;
replace unemp =  0.0415788 if sex==2 & agecat==4;
replace unemp =  0.040985 if sex==2 & agecat==5;
replace unemp =  0.0585256 if sex==2 & agecat==6;

gen inlf = labforce==2;
gen gainful = occ1950<980;

replace inlf = gainful if age<16;

gen employed = empstat==1 if year==93;
gen unemployed = empstat==2 if year==93;
gen noninlf = empstat==3 if year==93;

replace employed = inlf*(1-unemp) if year<93;

table year sex [w=perwt] if agecat==-1, c(mean employed);

log close;
