#delimit;

clear;

set more 1;

set memory 600m;

log using emppop.log, replace;

*  DERIVING EMPLOYMENT RATES FOR HOME PRODUCTION CALCULATIONS;

use c:\data\census\empschool190030.dta;

drop if relate==13;

gen employed = empstat==1 if year==93;
gen unemployed = empstat==2 if year==93;
gen noninlf = empstat==3 if year==93;

gen inlf = labforce==2;
gen gainful = occ1950<980;

replace inlf = gainful if age<16;

gen military=occ1950==595;

gen inlfciv = inlf==1 & military==0;
gen inlfmil = inlf==1 & military==1;

gen emplciv = employed==1 & military==0;
gen emplmil = employed==1 & military==1;

gen agecat = -1 if age<14 ;
replace agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

table year agecat sex [w=perwt], c(mean inlfciv);
table year agecat sex [w=perwt], c(mean inlfmil);

table agecat sex [w=perwt] if year==93, c(mean emplciv) ;
table agecat sex [w=perwt] if year==93, c(mean emplmil) ;

sum inlfciv [w=perwt] if year==90; gen suminlfciv = r(sum) if year==90;
sum inlfmil [w=perwt] if year==90; gen suminlfmil = r(sum) if year==90;
sum inlfciv [w=perwt] if year==91; replace suminlfciv = r(sum) if year==91;
sum inlfmil [w=perwt] if year==91; replace suminlfmil = r(sum) if year==91;
sum inlfciv [w=perwt] if year==92; replace suminlfciv = r(sum) if year==92;
sum inlfmil [w=perwt] if year==92; replace suminlfmil = r(sum) if year==92;
sum inlfciv [w=perwt] if year==93; replace suminlfciv = r(sum) if year==93;
sum inlfmil [w=perwt] if year==93; replace suminlfmil = r(sum) if year==93;
sum emplciv [w=perwt] if year==93; gen sumemplciv = r(sum) if year==93;
sum emplmil [w=perwt] if year==93; gen sumemplmil = r(sum) if year==93;

gen frlfciv = inlfciv/suminlfciv;
gen frlfmil = inlfmil/suminlfmil;
gen frempciv = emplciv/sumemplciv;
gen frempmil = emplmil/sumemplmil;

table year agecat sex [w=perwt], c(sum frlfciv);
table year agecat sex [w=perwt], c(sum frlfmil);

table year agecat sex [w=perwt] if year==93, c(sum frempciv);
table year agecat sex [w=perwt] if year==93, c(sum frempmil);

clear;

use c:\data\census\hoursocc4050.dta;

drop if relate==13;

gen employed = empstat==1;

gen military=occ1950==595;

gen emplciv = employed==1 & military==0;
gen emplmil = employed==1 & military==1;

gen agecat = -1 if age<14 ;
replace agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

table year agecat sex [w=perwt], c(mean emplciv);
table year agecat sex [w=perwt], c(mean emplmil);

sum emplciv [w=perwt] if year==94; gen sumemplciv = r(sum) if year==94;
sum emplmil [w=perwt] if year==94; gen sumemplmil = r(sum) if year==94;
sum emplciv [w=perwt] if year==95; replace sumemplciv = r(sum) if year==95;
sum emplmil [w=perwt] if year==95; replace sumemplmil = r(sum) if year==95;

gen frempciv = emplciv/sumemplciv;
gen frempmil = emplmil/sumemplmil;

table year agecat sex [w=perwt], c(sum frempciv);
table year agecat sex [w=perwt], c(sum frempmil);


clear;

use c:\data\census\hoursocc6070.dta;

drop if relate==13;

gen employed = empstat==1;

gen military=occ1950==595;

gen emplciv = employed==1 & military==0;
gen emplmil = employed==1 & military==1;

gen agecat = -1 if age<14 ;
replace agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

table year agecat sex [w=perwt], c(mean emplciv);
table year agecat sex [w=perwt], c(mean emplmil);

sum emplciv [w=perwt] if year==96; gen sumemplciv = r(sum) if year==96;
sum emplmil [w=perwt] if year==96; gen sumemplmil = r(sum) if year==96;
sum emplciv [w=perwt] if year==97; replace sumemplciv = r(sum) if year==97;
sum emplmil [w=perwt] if year==97; replace sumemplmil = r(sum) if year==97;

gen frempciv = emplciv/sumemplciv;
gen frempmil = emplmil/sumemplmil;

table year agecat sex [w=perwt], c(sum frempciv);
table year agecat sex [w=perwt], c(sum frempmil);



clear;

set memory 800m;

use c:\data\census\hoursocc8000.dta;

drop if relate==13;

gen employed = empstat==1;

gen military=occ1950==595;

gen emplciv = employed==1 & military==0;
gen emplmil = employed==1 & military==1;

gen agecat = -1 if age<14 ;
replace agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

table year agecat sex [w=perwt], c(mean emplciv);
table year agecat sex [w=perwt], c(mean emplmil);

sum emplciv [w=perwt] if year==98; gen sumemplciv = r(sum) if year==98;
sum emplmil [w=perwt] if year==98; gen sumemplmil = r(sum) if year==98;
sum emplciv [w=perwt] if year==99; replace sumemplciv = r(sum) if year==99;
sum emplmil [w=perwt] if year==99; replace sumemplmil = r(sum) if year==99;
sum emplciv [w=perwt] if year==00; replace sumemplciv = r(sum) if year==00;
sum emplmil [w=perwt] if year==00; replace sumemplmil = r(sum) if year==00;

gen frempciv = emplciv/sumemplciv;
gen frempmil = emplmil/sumemplmil;

table year agecat sex [w=perwt], c(sum frempciv);
table year agecat sex [w=perwt], c(sum frempmil);

log close;


