# delimit;

clear;

set more 1;
set mem 400m;

log using bls.log, replace;

use c:\homeproduction\timeuse\bls_datasets.dta; 

/*ADJUST GARDENING NUMBERS USING 1998 FISCTA SURVEY*/

gen garden_petvar = 0.04*(extclean + lawngarden + pool) + pet;

replace garden_petvar = 0.06*(extclean + lawngarden + pool) + pet
  if male==0 & working==0 & age>=18 & age<65;

replace garden_petvar = 0.15*(extclean + lawngarden + pool) + pet
  if male==0 & working==0 & age>=18 & age<65;

replace garden_petvar = 0.03*(extclean + lawngarden + pool) + pet
  if male==0 & age>=18 & age<65;

gen play = hhplay + nonhhplay;

/*ALLARD ET AL MLR ARTICLE SAYS THAT EARLIER INCLUDED NONHOUSEHOLD CHILDREN*/

gen homeprod0 = housework + hhcare + nonhhcare + purchasing + travel - garden_petvar - play;
gen homeprod1 = housework + hhcare + nonhhcare + purchasing + travel - garden_petvar;
gen homeprod2 = housework + hhcare + purchasing + travel - hhplay - garden_petvar;

gen dataset_03 = dataset==2003;
gen dataset_04 = dataset==2004;
gen dataset_05 = dataset==2005;


local dataset dataset_03 dataset_04 dataset_05;

/*variables to be studied:*/

local variables homeprod0 ;


*FEMALE NONEMPLOYED, AGES 18-24;
*********************************;

local sample = " if male==0 & age>=18 & age<25 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE NONEMPLOYED, AGES 25-54;
*********************************;

local sample = " if male==0 & age>=25 & age<55 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE NONEMPLOYED, AGES 55-64;
*********************************;

local sample = " if male==0 & age>=55 & age<65 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*FEMALE EMPLOYED, AGES 18-24;
*********************************;

local sample = " if male==0 & age>=18 & age<25 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 25-54;
*********************************;

local sample = " if male==0 & age>=25 & age<55 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 55-64;
*********************************;

local sample = " if male==0 & age>=55 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE NONEMPLOYED, AGES 18-24;
*********************************;

local sample = " if male==1 & age>=18 & age<25 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE NONEMPLOYED, AGES 25-54;
*********************************;

local sample = " if male==1 & age>=25 & age<55 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE NONEMPLOYED, AGES 55-64;
*********************************;

local sample = " if male==1 & age>=55 & age<65 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*MALE EMPLOYED, AGES 18-24;
*********************************;

local sample = " if male==1 & age>=18 & age<25 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE EMPLOYED, AGES 25-54;
*********************************;

local sample = " if male==1 & age>=25 & age<55 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE EMPLOYED, AGES 55-64;
*********************************;

local sample = " if male==1 & age>=55 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};
/*

*FEMALE EMPLOYED, AGES 18-64;
*********************************;

local sample = " if male==0 & age>=18 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE EMPLOYED & MARRIED, AGES 18-64;
*********************************;

local sample = " if male==0 & married==1 & age>=18 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*FEMALE EMPLOYED & EVER MARRIED, AGES 18-64;
*********************************;

local sample = " if male==0 & marst~=6 & age>=18 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE EMPLOYED & SINGLE, AGES 18-64;
*********************************;

local sample = " if male==0 & marst==6 & age>=18 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};



*FEMALE ALL, AGES 18-64;
*********************************;

local sample = " if male==0 & age>=18 & age<65 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*MALE EMPLOYED, AGES 18-64;
*********************************;

local sample = " if male==1 & age>=18 & age<65 & working==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*MALE NONEMPLOYED, AGES 18-64;
*********************************;

local sample = " if male==1 & age>=18 & age<65 & working==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*MALE ALL, AGES 18-64;
*********************************;

local sample = " if male==1 & age>=18 & age<65";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*ALL, AGES 18-64;
*********************************;

local sample = " if age>=18 & age<65";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};



*FEMALE NON-EMPLOYED, AGES 65+;
*********************************;

local sample = " if male==0 & age>=65 & working==0 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 65+;
*********************************;

local sample = " if male==0 & age>=65 & working==1 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*MALE NON-EMPLOYED, AGES 65+;
*********************************;

local sample = " if male==1 & age>=65 & working==0 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};


*MALE EMPLOYED, AGES 65+;
*********************************;

local sample = " if male==1 & age>=65 & working==1 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*Males, AGES 65+;
*********************************;

local sample = " if age>=65 & male==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*Females, AGES 65+;
*********************************;

local sample = " if age>=65 & male==0";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*ALL AGES 65+;
*********************************;

local sample = " if age>=65 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};

*Children, ages 15-17;
*********************************;

local sample = " if age>=15 & age<=17";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=weight_adj] `sample', noc;
	};
*/

log close;
