#delimit;
clear;

set memory 400m;

log using unemp0030.log, replace;

use c:\data\census\empschool190030.dta;

drop if relate==13;

gen employed = empstat==1 if year==91 | year==93;
gen unemployed = empstat==2 if year==91 | year==93;
gen noninlf = empstat==3 if  year==91 | year==93;

gen inlf = (empstat==1 | empstat==2);

gen inschool = school==2;

gen agecat = -4 if age>=10 & age<14 & inschool==1;
replace agecat = -3 if age>=10 & age<14 & inschool==0;
replace agecat = -2 if age>=14 & age<18 & inschool==1;
replace agecat = -1 if age>=14 & age<18 & inschool==0;
replace agecat = 0 if age>=18 & age<25 & inschool==1;
replace agecat = 1 if age>=18 & age<25 & inschool==0;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

gen military=occ1950==595;
gen civilian = 1- military;

summ unemployed [w=perwt] if inlf==1 & year==91;
summ unemployed [w=perwt] if inlf==1 & year==93;

table year agecat sex [w=perwt] if (year==91 | year==93) & inlf==1 
  & military==0, c(mean unemployed);

table year agecat sex [w=perwt] if (year==91 | year==93) & inlf==1,
   c(mean unemployed);

gen agecat2 = 1 if age>=18 & age<25;
replace agecat2 = 2 if age>=25 & age<55;
replace agecat2 = 5 if age>=55 & age<65;
replace agecat2 = 6 if age>=65;

drop if agecat2==.;


table year agecat2 sex [w=perwt] if (year==91 | year==93) & inlf==1 
  & military==0, c(mean unemployed);

table year agecat2 sex [w=perwt] if (year==91 | year==93) & inlf==1 
  , c(mean unemployed);

log close;
