#delimit;
clear;

set memory 400m;

log using pop8000.log, replace;

*  Population;

use c:\data\census\hoursocc8000.dta;

drop if relate==13;

gen agecat = -4 if age>=10 & age<14;
replace agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

collapse (sum) perwt, by(year sex agecat);

gen popth = perwt/1000;

list year sex agecat popth ;

outsheet year sex agecat popth using junk.csv, comma replace;

log close;
