#delimit;
clear;

set memory 400m;

log using militaryhrs.log, replace;

/* CALCULATES MILITARY HOURS FRACTIONS BY AGE-SEX GROUP */

use c:\data\census\hrsschool194050.dta;

drop if relate==13;

drop wkswork1 wkswork2 race;

gen hrswork = hrswork1 if year==94 | year==95;

replace hrswork = 0 if hrswork==.;

*employed, but not emergency worker whose hours weren't counted in 1940;

gen employed = empstat==1 & empstatd~=11;
gen employedz = empstat==1;

gen unemployed = empstat==2;
gen noninlf = empstat==3;

gen inschool = school==2;

gen agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

gen military = occ1950==595;
gen civilian = 1 - military;

gen employmil = empstat==1 & empstatd~=11 & military==1;
gen employciv = empstat==1 & empstatd~=11 & civilian==1;

gen hrsworkmil = 0; replace hrsworkmil = hrswork if military==1;

summ hrsworkmil [w=perwt] if year==94; gen sumhrsworkmil = r(sum) if year==94;

summ hrsworkmil [w=perwt] if year==95; replace sumhrsworkmil = r(sum) if year==95;

gen hrsmilfr = hrsworkmil/sumhrsworkmil;

*table sex agecat [w=perwt] if year==94, c(sum hrsmilfr) row;

table sex agecat [w=perwt] if year==95, c(sum hrsmilfr) row;

sum employmil [w=perwt] if year==94; gen sumemploymil= r(sum) if year==94;

sum employmil [w=perwt] if year==95; replace sumemploymil= r(sum) if year==95;

gen empmilfr = employmil/sumemploymil;

*table sex agecat [w=perwt] if year==94, c(sum empmilfr) ;

table sex agecat [w=perwt] if year==95, c(sum empmilfr) ;

clear;

set memory 400m;


use c:\data\census\hoursocc6070.dta;

drop if relate==13;

drop wkswork1 wkswork2 race;

gen agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

sort year sex agecat hrswork2 ;

*THESE ARE DATA FOR CALCULATING MEANS FOR INTERVALLED DATA;

merge year sex agecat hrswork2 using interval50.dta;
tab _merge; drop _merge;

sort year sex agecat hrswork2 ;

merge year sex agecat hrswork2 using interval80.dta;
tab _merge; drop _merge;

*These intervaled numbers are based on my computations for overlap;

gen hrswork = interval50*(hrswork2==1) + interval50*(hrswork2==2)
  + interval50*(hrswork2==3) + interval50*(hrswork2==4)
  + interval50*(hrswork2==5) + interval50*(hrswork2==6)
  + interval50*(hrswork2==7) + interval50*(hrswork2==8) if year==96;

replace hrswork = interval80*(hrswork2==1) + interval80*(hrswork2==2)
  + interval80*(hrswork2==3) + interval80*(hrswork2==4)
  + interval80*(hrswork2==5) + interval80*(hrswork2==6)
  + interval80*(hrswork2==7) + interval80*(hrswork2==8) if year==97;

replace hrswork = 0 if hrswork==.;

drop if agecat==.;

gen military = occ1950==595;
gen civilian = 1 - military;

gen employmil = empstat==1 & military==1;

gen hrsworkmil = 0; replace hrsworkmil = hrswork if military==1;

summ hrsworkmil [w=perwt] if year==96; gen sumhrsworkmil = r(sum) if year==96;

summ hrsworkmil [w=perwt] if year==97; replace sumhrsworkmil=r(sum) if year==97;

gen hrsmilfr = hrsworkmil/sumhrsworkmil;

table sex agecat [w=perwt] if year==96, c(sum hrsmilfr) ;

table sex agecat [w=perwt] if year==97, c(sum hrsmilfr) ;


sum employmil [w=perwt] if year==96; gen sumemploymil= r(sum) if year==96;

sum employmil [w=perwt] if year==97; replace sumemploymil= r(sum) if year==97;

gen empmilfr = employmil/sumemploymil;

table sex agecat [w=perwt] if year==96, c(sum empmilfr) ;

table sex agecat [w=perwt] if year==97, c(sum empmilfr) ;

clear;

set memory 800m;

use c:\data\census\hoursocc8000.dta;

drop if relate==13;

drop wkswork1 wkswork2 race relate educrec marst gq;

drop if age<14;

gen hrswork = hrswork1 if year==98 | year==99;
replace hrswork = uhrswork if year==00;

replace hrswork = 0 if hrswork==.;

gen employed = empstat==1;
gen unemployed = empstat==2;
gen noninlf = empstat==3;

gen agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

gen military = occ1950==595;
gen civilian = 1 - military;

gen employmil = empstat==1 & military==1;

gen hrsworkmil = 0; replace hrsworkmil = hrswork if military==1;

summ hrsworkmil [w=perwt] if year==98; gen sumhrsworkmil = r(sum) if year==98;

summ hrsworkmil [w=perwt] if year==99; replace sumhrsworkmil=r(sum) if year==99;

summ hrsworkmil [w=perwt] if year==00; replace sumhrsworkmil=r(sum) if year==00;

gen hrsmilfr = hrsworkmil/sumhrsworkmil;

table sex agecat [w=perwt] if year==98, c(sum hrsmilfr) ;

table sex agecat [w=perwt] if year==99, c(sum hrsmilfr) ;

table sex agecat [w=perwt] if year==00, c(sum hrsmilfr) ;


sum employmil [w=perwt] if year==98; gen sumemploymil= r(sum) if year==98;

sum employmil [w=perwt] if year==99; replace sumemploymil= r(sum) if year==99;

sum employmil [w=perwt] if year==00; replace sumemploymil= r(sum) if year==00;

gen empmilfr = employmil/sumemploymil;

table sex agecat [w=perwt] if year==98, c(sum empmilfr) ;

table sex agecat [w=perwt] if year==99, c(sum empmilfr) ;

table sex agecat [w=perwt] if year==00, c(sum empmilfr) ;

log close;

