#delimit;
clear;

set memory 400m;

log using hrs4050.log, replace;

use c:\data\census\hrsschool194050.dta;

drop if relate==13;

drop wkswork1 wkswork2 race;

gen hrswork = hrswork1 if year==94 | year==95;

replace hrswork = 0 if hrswork==.;


gen employed = empstat==1;
gen unemployed = empstat==2;
gen noninlf = empstat==3;

gen military = occ1950==595;
gen civilian = 1 - military;

gen agecat = 0 if age>=14 & age<18;
replace agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

/* ADJUST FOR FACT THAT CENSUS IS IN MAR-APRIL & TEEN EMPLOYMENT GOES UP
IN SUMMER.  USE RATIO OF ANNUAL TO MARCH FOR TEENS RELATIVE TO ANNUAL TO MARCH
FOR EVERYONE 16+.  Acc. to monthly CPS from 1977 on, no difference for
all 16+, but for 16-17, annual hours*emp is 30 percent higher than March for
males and 26 per cent for females.  For 18-24, it's 6 percent for males
and 4 percent for female. CPS data from 1977 - 2007 shows no trend. */

replace hrswork = 1.30*hrswork if sex==1 & agecat==0;
replace hrswork = 1.26*hrswork if sex==2 & agecat==0;
replace hrswork = 1.06*hrswork if sex==1 & agecat==1;
replace hrswork = 1.04*hrswork if sex==2 & agecat==1;

sum hrswork [w=perwt] if year==94; gen sumhrswork = r(sum) if year==94;

sum hrswork [w=perwt] if year==95; replace sumhrswork = r(sum) if year==95;

gen frhr = hrswork/sumhrswork;

gen hrsworkciv = 0; replace hrsworkciv = hrswork if military==0;
gen hrsworkmil = 0; replace hrsworkmil = hrswork if military==1;

summ hrsworkciv [w=perwt] if year==94; gen sumhrsworkciv = r(sum) if year==94;
summ hrsworkmil [w=perwt] if year==94; gen sumhrsworkmil = r(sum) if year==94;

summ hrsworkciv [w=perwt] if year==95; replace sumhrsworkciv = r(sum) if year==95;
summ hrsworkmil [w=perwt] if year==95; replace sumhrsworkmil = r(sum) if year==95;

gen hrscivfr = hrsworkciv/sumhrsworkciv;
gen hrsmilfr = hrsworkmil/sumhrsworkmil;

table sex agecat [w=perwt] if year==94, c(sum frhr) row;
table sex agecat [w=perwt] if year==95, c(sum frhr) row;

table sex agecat [w=perwt] if year==94, c(sum hrscivfr) row;
table sex agecat [w=perwt] if year==94, c(sum hrsmilfr) row;

table sex agecat [w=perwt] if year==95, c(sum hrscivfr) row;
table sex agecat [w=perwt] if year==95, c(sum hrsmilfr) row;


*CALCULATE INTERVAL MEANS FOR 1950 FOR USE FOR 1960;

table hrswork2 sex agecat [w=perwt] if year==95, c(mean hrswork1) ;

log close;
