#delimit;
clear;

set memory 400m;

log using hrs0030.log, replace;

* hrs190030.do, by V. Ramey; 

*  DERIVING FRACTIONS FOR PARSING TOTAL HOURS BY GROUP;

use c:\data\census\empschool190030.dta;

drop if relate==13;

/* NOTE THAT THE LABOR FORCE VARIABLE IS ONLY ASKED FOR THOSE 16+ IN 1900-30
I THUS USE GAINFUL WORKERS FOR 14-15 YEAR OLDS.  FOR 15-16 YEAR OLDS, GAINFUL 
WORKER AND IN THE LABOR FORCE RATIOS ARE ALMOST IDENTICAL, SO I AM VERY 
CONFIDENT OF THE SUBSTITUION */



gen inschool = school==2;

gen agecat = -4 if age>=10 & age<14 & inschool==1;
replace agecat = -3 if age>=10 & age<14 & inschool==0;
replace agecat = -2 if age>=14 & age<18 & inschool==1;
replace agecat = -1 if age>=14 & age<18 & inschool==0;
replace agecat = 0 if age>=18 & age<25 & inschool==1;
replace agecat = 1 if age>=18 & age<25 & inschool==0;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

*THESE UNEMPLOYMENT RATES WERE CALCULATED FROM EMPSTAT VARIABLE IN 1910;

gen unempciv = 0.0217305 if sex== 1 & agecat== -4;
replace unempciv = 0.0298605 if sex== 1 & agecat== -3;
replace unempciv = 0.0292757 if sex== 1 & agecat== -2;
replace unempciv = 0.0406258 if sex== 1 & agecat== -1;
replace unempciv = 0.0432268 if sex== 1 & agecat== 0;
replace unempciv = 0.045374 if sex== 1 & agecat== 1;
replace unempciv = 0.0498483 if sex== 1 & agecat== 2;
replace unempciv = 0.0504271 if sex== 1 & agecat== 3;
replace unempciv = 0.0425217 if sex== 1 & agecat== 4;
replace unempciv = 0.063405 if sex== 1 & agecat== 5;
replace unempciv = 0.1047295 if sex== 1 & agecat== 6;
replace unempciv = 0.0396488 if sex== 2 & agecat== -4;
replace unempciv = 0.0294962 if sex== 2 & agecat== -3;
replace unempciv = 0.0423276 if sex== 2 & agecat== -2;
replace unempciv = 0.0416107 if sex== 2 & agecat== -1;
replace unempciv = 0.0603681 if sex== 2 & agecat== 0;
replace unempciv = 0.0440633 if sex== 2 & agecat== 1;
replace unempciv = 0.0498068 if sex== 2 & agecat== 2;
replace unempciv = 0.0466647 if sex== 2 & agecat== 3;
replace unempciv = 0.0415788 if sex== 2 & agecat== 4;
replace unempciv = 0.040985 if sex== 2 & agecat== 5;
replace unempciv = 0.0585256 if sex== 2 & agecat== 6;

gen unemp = 0.0217303 if sex==1 & agecat==-4;
replace unemp =  0.0298605 if sex==1 & agecat==-3;
replace unemp =  0.0292614 if sex==1 & agecat==-2;
replace unemp =  0.0405808 if sex==1 & agecat==-1;
replace unemp =  0.0429261 if sex==1 & agecat==-0;
replace unemp =  0.0449412 if sex==1 & agecat==1;
replace unemp =  0.0495997 if sex==1 & agecat==2;
replace unemp =  0.0503231 if sex==1 & agecat==3;
replace unemp =  0.0424881 if sex==1 & agecat==4;
replace unemp =  0.063371 if sex==1 & agecat==5;
replace unemp =  0.1046966 if sex==1 & agecat==6;
replace unemp =  0.0396488 if sex==2 & agecat==-4;
replace unemp =  0.0294962 if sex==2 & agecat==-3;
replace unemp =  0.0423276 if sex==2 & agecat==-2;
replace unemp =  0.0416107 if sex==2 & agecat==-1;
replace unemp =  0.0603681 if sex==2 & agecat==-0;
replace unemp =  0.0440633 if sex==2 & agecat==1;
replace unemp =  0.0498047 if sex==2 & agecat==2;
replace unemp =  0.0466647 if sex==2 & agecat==3;
replace unemp =  0.0415788 if sex==2 & agecat==4;
replace unemp =  0.040985 if sex==2 & agecat==5;
replace unemp =  0.0585256 if sex==2 & agecat==6;

gen inlf = labforce==2;
gen gainful = occ1950<980;

replace inlf = gainful if age<16;

gen employed = empstat==1 if year==93;
gen unemployed = empstat==2 if year==93;
gen noninlf = empstat==3 if year==93;

replace employed = inlf*(1-unemp) if year<93;

gen military=occ1950==595;
gen civilian = 1- military;

*This hours/employment factor calculated from 1940 (hefactor.do);
*Based on employed (not emergency work since their hours not recorded);

gen hefactor = 0.620 if sex==1 & agecat==-4;
replace hefactor = 0.986 if sex==1 & agecat==-3;
replace hefactor = 0.620 if sex==1 & agecat==-2;
replace hefactor = 0.986 if sex==1 & agecat==-1;
replace hefactor = 0.810 if sex==1 & agecat==0;
replace hefactor = 1.008 if sex==1 & agecat==1;
replace hefactor = 1.030 if sex==1 & agecat==2;
replace hefactor = 1.040 if sex==1 & agecat==3;
replace hefactor = 1.041 if sex==1 & agecat==4;
replace hefactor = 1.031 if sex==1 & agecat==5;
replace hefactor = 0.999 if sex==1 & agecat==6;

replace hefactor = 0.628 if sex==2 & agecat==-4;
replace hefactor = 0.889 if sex==2 & agecat==-3;
replace hefactor = 0.628 if sex==2 & agecat==-2;
replace hefactor = 0.889 if sex==2 & agecat==-1;
replace hefactor = 0.847 if sex==2 & agecat==0;
replace hefactor = 0.926 if sex==2 & agecat==1;
replace hefactor = 0.917 if sex==2 & agecat==2;
replace hefactor = 0.920 if sex==2 & agecat==3;
replace hefactor = 0.930 if sex==2 & agecat==4;
replace hefactor = 0.941 if sex==2 & agecat==5;
replace hefactor = 0.938 if sex==2 & agecat==6;

gen hefactorciv = 0.619 if sex==1 & agecat==-4;
replace hefactorciv = 0.986 if sex==1 & agecat==-3;
replace hefactorciv = 0.619 if sex==1 & agecat==-2;
replace hefactorciv = 0.986 if sex==1 & agecat==-1;
replace hefactorciv = 0.803 if sex==1 & agecat==0;
replace hefactorciv = 1.008 if sex==1 & agecat==1;
replace hefactorciv = 1.030 if sex==1 & agecat==2;
replace hefactorciv = 1.040 if sex==1 & agecat==3;
replace hefactorciv = 1.042 if sex==1 & agecat==4;
replace hefactorciv = 1.032 if sex==1 & agecat==5;
replace hefactorciv = 0.999 if sex==1 & agecat==6;

replace hefactorciv = 0.628 if sex==2 & agecat==-4;
replace hefactorciv = 0.890 if sex==2 & agecat==-3;
replace hefactorciv = 0.628 if sex==2 & agecat==-2;
replace hefactorciv = 0.890 if sex==2 & agecat==-1;
replace hefactorciv = 0.847 if sex==2 & agecat==0;
replace hefactorciv = 0.927 if sex==2 & agecat==1;
replace hefactorciv = 0.917 if sex==2 & agecat==2;
replace hefactorciv = 0.921 if sex==2 & agecat==3;
replace hefactorciv = 0.930 if sex==2 & agecat==4;
replace hefactorciv = 0.941 if sex==2 & agecat==5;
replace hefactorciv = 0.938 if sex==2 & agecat==6;

/*I USED THE SAME MILITARY FACTOR FOR MEN AND WOMEN BECAUSE THE WOMEN
  NUMBERS WERE SO FEW THEY WERE INACCURATE*/

gen hefactormil = 0.975 if agecat==-4;
replace hefactormil = 1.138 if agecat==-3;
replace hefactormil = 0.975 if agecat==-2;
replace hefactormil = 1.138 if agecat==-1;
replace hefactormil = 0.949 if agecat==0;
replace hefactormil = 0.998 if agecat==1;
replace hefactormil = 1.001 if agecat==2;
replace hefactormil = 1.003 if agecat==3;
replace hefactormil = 1.010 if agecat==4;
replace hefactormil = 1.094 if agecat==5;
replace hefactormil = 1.008 if agecat==6;

gen hrswork = 0;

replace hrswork = hefactor*employed;


/* ADJUST FOR FACT THAT CENSUS DOESN'T PICK UP SUMMER JOBS OF STUDENTS
  0.75 IS SCHOOL YEAR, .25 IS SUMMER
  0.986(0.889) IS HOURS FACTORS FOR MALE (FEMALE) TEENS WHO ARE NOT STUDENTS
  0.80,.75,.71,.63 IS EMPLOYMENT RATE OF 14-17 MALES NOT IN SCHOOL 
  0.40, 0.42, 0.44, 0.35 is employment rate of 14-17 females not in school
*/


replace hrswork = .75*hefactor*employed + .25*.986*.80 if agecat==-2 
  & sex==1 & year==90;

replace hrswork = .75*hefactor*employed + .25*.986*.75 if agecat==-2 
  & sex==1 & year==91;

replace hrswork = .75*hefactor*employed + .25*.986*.71 if agecat==-2 
  & sex==1 & year==92;

replace hrswork = .75*hefactor*employed + .25*.986*.63 if agecat==-2 
  & sex==1 & year==93;

replace hrswork = .75*hefactor*employed + .25*.889*.40 if agecat==-2 
  & sex==2 & year==90;

replace hrswork = .75*hefactor*employed + .25*.889*.42 if agecat==-2 
  & sex==2 & year==91;

replace hrswork = .75*hefactor*employed + .25*.889*.44 if agecat==-2 
  & sex==2 & year==92;

replace hrswork = .75*hefactor*employed + .25*.889*.35 if agecat==-2 
  & sex==2 & year==93;

gen agecat2 = -1 if age>=10 & age<14;
replace agecat2 = 0 if age>=14 & age<18;
replace agecat2 = 1 if age>=18 & age<25;
replace agecat2 = 2 if age>=25 & age<35;
replace agecat2 = 3 if age>=35 & age<45;
replace agecat2 = 4 if age>=45 & age<55;
replace agecat2 = 5 if age>=55 & age<65;
replace agecat2 = 6 if age>=65;

sum hrswork [w=perwt] if year==90; gen sumhrswork = r(sum) if year==90;
sum hrswork [w=perwt] if year==91; replace sumhrswork = r(sum) if year==91;
sum hrswork [w=perwt] if year==92; replace sumhrswork = r(sum) if year==92;
sum hrswork [w=perwt] if year==93; replace sumhrswork = r(sum) if year==93;

* FRACTION OF TOTAL HOURS WORKED ACCOUNTED FOR BY EACH AGE-SEX GROUP;

gen frhr = hrswork/sumhrswork;

table sex agecat2 [w=perwt] if year==90, c(sum frhr) row;
*table sex agecat2 [w=perwt] if year==91, c(sum frhr) row;
table sex agecat2 [w=perwt] if year==92, c(sum frhr) row;
table sex agecat2 [w=perwt] if year==93, c(sum frhr) row;

log close;

