#delimit;
clear;

set memory 400m;

log using hefactor.log, replace;

*hefactor.do, by V. Ramey;

/* This file constructs hefactor: the ratio of hours per employed worker
  by age-sex relative to the aggregate average.  This factor is used to turn
  employment rates into hours for the period from 1900-1930. */

use c:\data\census\hrsschool194050.dta;

drop if relate==13;

drop wkswork1 wkswork2 race;

gen hrswork = hrswork1 if year==94 | year==95;

replace hrswork = 0 if hrswork==.;

/* Employed, but not emergency worker whose hours weren't counted in 1940
  Thus drop empstatd==11 */

gen employed = empstat==1 & empstatd~=11;
gen employedz = empstat==1;

gen unemployed = empstat==2;
gen noninlf = empstat==3;

* School status;

gen inschool = school==2;

gen agecat = -2 if age>=14 & age<18 & inschool==1;
replace agecat = -1 if age>=14 & age<18 & inschool==0;
replace agecat = 0 if age>=18 & age<25 & inschool==1;
replace agecat = 1 if age>=18 & age<25 & inschool==0;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
replace agecat = 6 if age>=65;

drop if agecat==.;

gen military = occ1950==595;
gen civilian = 1 - military;

gen employciv = empstat==1 & empstatd~=11 & civilian==1;
gen employmil = empstat==1 & empstatd~=11 & military==1;


*Aggregate hours per employee;

summ hrswork [w=perwt] if year==94 & employed==1;
summ hrswork [w=perwt] if year==94 & employciv==1;
summ hrswork [w=perwt] if year==94 & employmil==1;


*Hours by age-sex;

table sex agecat [w=perwt] if year==94 & employed==1, c(mean hrswork) row;
table sex agecat [w=perwt] if year==94 & employciv==1, c(mean hrswork) row;
table sex agecat [w=perwt] if year==94 & employmil==1, c(mean hrswork) row;


log close;

