#delimit;
set more 1;

clear;

log using femalehp.log, replace;

/* THIS FILE CALCULATES NUMBER OF CHILDREN AND AGE OF CHILDREN FOR 
  NONEMPLOYED WOMEN FOR HOME PRODUCTION ESTIMATES. */

set memory 500m;

use c:\data\census\hhdat190020.dta;

keep year datanum serial pernum age;
  keep if age>=18;
  sort year datanum serial pernum;
  collapse (count) age, by (year datanum serial);
  rename age nadult;
  sort year datanum serial;
  save temp1.dta, replace; 


use c:\data\census\hhdat190020.dta;
keep year datanum serial momloc age;

rename momloc pernum;
  keep if age<18 & pernum>0;
  gen nteen = age>=14;
  sort year datanum serial pernum;
  collapse (count) age (sum) nteen, by (year datanum serial pernum);
  rename age ownchild0_17;
  gen teen = nteen>0;
  sort year datanum serial pernum;
  save temp2.dta, replace;

use c:\data\census\hhdat190020.dta;
  sort year datanum serial pernum;
  merge year datanum serial using temp1.dta;
  tab _merge; drop _merge;
  sort year datanum serial pernum;
  merge year datanum serial pernum using temp2.dta;
  tab _merge; drop _merge;
  replace ownchild0_17 = 0 if ownchild0_17==.;
  replace teen = 0 if teen==.;

gen ownchild2 = ownchild0_17^2;
gen othchild0_17 = numprec - nadult - ownchild0_17;

summ numprec nadult ownchild0_17 othchild0_17;

/*
gen empsinglef18_64 = (sex==2 & labforce==2 & relate~=13 
  & marst==6 & age>=18 & age<65);

gen empsinglef = (sex==2 & labforce==2 & relate~=13 & marst==6 & age>=18);
*/

gen nonempf18_24 = (sex==2 & labforce==1 & relate~=13 & age>=18 & age<25);
gen nonempf25_54 = (sex==2 & labforce==1 & relate~=13 & age>=25 & age<55);
gen nonempf55_64 = (sex==2 & labforce==1 & relate~=13 & age>=55 & age<65);

gen infant = (nchild>0 & yngch<1);
gen toddler = (nchild>0 & yngch>=1 & yngch<6);

summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==90;
summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==91;
summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==92;

summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==90;
summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==91;
summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==92;

summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==90;
summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==91;
summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==92;

clear;


use c:\data\census\hhdat193040.dta;

keep year datanum serial pernum age;
  keep if age>=18;
  sort year datanum serial pernum;
  collapse (count) age, by (year datanum serial);
  rename age nadult;
  sort year datanum serial;
  save temp1.dta, replace; 


use c:\data\census\hhdat193040.dta;
keep year datanum serial momloc age;

rename momloc pernum;
  keep if age<18 & pernum>0;
  gen nteen = age>=14;
  sort year datanum serial pernum;
  collapse (count) age (sum) nteen, by (year datanum serial pernum);
  rename age ownchild0_17;
  gen teen = nteen>0;
  sort year datanum serial pernum;
  save temp2.dta, replace;

use c:\data\census\hhdat193040.dta;
  sort year datanum serial pernum;
  merge year datanum serial using temp1.dta;
  tab _merge; drop _merge;
  sort year datanum serial pernum;
  merge year datanum serial pernum using temp2.dta;
  tab _merge; drop _merge;
  replace ownchild0_17 = 0 if ownchild0_17==.;
  replace teen = 0 if teen==.;

gen ownchild2 = ownchild0_17^2;
gen othchild0_17 = numprec - nadult - ownchild0_17;

summ numprec nadult ownchild0_17 othchild0_17;

gen nonempf18_24 = (sex==2 & labforce==1 & relate~=13 & age>=18 & age<25);
gen nonempf25_54 = (sex==2 & labforce==1 & relate~=13 & age>=25 & age<55);
gen nonempf55_64 = (sex==2 & labforce==1 & relate~=13 & age>=55 & age<65);

gen infant = (nchild>0 & yngch<1);
gen toddler = (nchild>0 & yngch>=1 & yngch<6);

summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==93;
summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==94;

summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==93;
summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==94;

summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==93;
summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==94;


clear;

use c:\data\census\hhdat195060.dta;

keep year datanum serial pernum age;
  keep if age>=18;
  sort year datanum serial pernum;
  collapse (count) age, by (year datanum serial);
  rename age nadult;
  sort year datanum serial;
  save temp1.dta, replace; 


use c:\data\census\hhdat195060.dta;
keep year datanum serial momloc age;

rename momloc pernum;
  keep if age<18 & pernum>0;
  gen nteen = age>=14;
  sort year datanum serial pernum;
  collapse (count) age (sum) nteen, by (year datanum serial pernum);
  rename age ownchild0_17;
  gen teen = nteen>0;
  sort year datanum serial pernum;
  save temp2.dta, replace;

use c:\data\census\hhdat195060.dta;
  sort year datanum serial pernum;
  merge year datanum serial using temp1.dta;
  tab _merge; drop _merge;
  sort year datanum serial pernum;
  merge year datanum serial pernum using temp2.dta;
  tab _merge; drop _merge;
  replace ownchild0_17 = 0 if ownchild0_17==.;
  replace teen = 0 if teen==.;

gen ownchild2 = ownchild0_17^2;
gen othchild0_17 = numprec - nadult - ownchild0_17;

summ numprec nadult ownchild0_17 othchild0_17;

gen nonempf18_24 = (sex==2 & labforce==1 & relate~=13 & age>=18 & age<25);
gen nonempf25_54 = (sex==2 & labforce==1 & relate~=13 & age>=25 & age<55);
gen nonempf55_64 = (sex==2 & labforce==1 & relate~=13 & age>=55 & age<65);

gen infant = (nchild>0 & yngch<1);
gen toddler = (nchild>0 & yngch>=1 & yngch<6);

summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==95;
summ infant toddler ownchild0_17 [w=perwt] if nonempf18_24==1 & year==96;

summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==95;
summ infant toddler ownchild0_17 [w=perwt] if nonempf25_54==1 & year==96;

summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==95;
summ infant toddler ownchild0_17 [w=perwt] if nonempf55_64==1 & year==96;

log close;
