# delimit;

clear;

set more 1;
set mem 400m;

log using ahtus.log, replace;

use "c:\timeusedata\ahtus\ahtus.dta"; 

gen homeprod0 = (7/60)*(tmain20 + tmain21 + tmain22 + tmain23 + tmain24 
  + tmain25 + tmain26 + tmain27 + tmain30 + tmain31 
  + tmain32 + tmain33 + tmain34 + tmain35 + tmain37 + tmain38 + tmain39 
  + tmain40 + tmain95 + tmain96); 
  /*Excludes garden and pet, purchasing medical and personal care services,
  excludes playing with children*/

gen work_core = (7/60)*(tmain10 + tmain11 + tmain12);

gen dataset=1965 if survey==0 | survey==1;
replace dataset=1975 if survey==2;
replace dataset=1985 if survey==3;
replace dataset=1993 if survey==4;
replace dataset=2003 if survey==7;

gen dataset_65 = dataset==1965;
gen dataset_75 = dataset==1975;
gen dataset_85 = dataset==1985;
gen dataset_93 = dataset==1993;
gen dataset_03 = dataset==2003;


*local dataset dataset_65 dataset_75 dataset_85 dataset_93 dataset_03 ;
local dataset dataset_65 dataset_75 dataset_85 dataset_03 ;

/*variables to be studied:*/

local variables homeprod0 ;



*FEMALE NONEMPLOYED, AGES 18-24;
*********************************;

local sample = " if sex==2 & age>=18 & age<25 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE NONEMPLOYED, AGES 25-54;
*********************************;

local sample = " if sex==2 & age>=25 & age<55 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE NONEMPLOYED, AGES 55-64;
*********************************;

local sample = " if sex==2 & age>=55 & age<65 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 18-24;
*********************************;

local sample = " if sex==2 & age>=18 & age<25 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 25-54;
*********************************;

local sample = " if sex==2 & age>=25 & age<55 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 55-64;
*********************************;

local sample = " if sex==2 & age>=55 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*MALE NONEMPLOYED, AGES 18-24;
*********************************;

local sample = " if sex==1 & age>=18 & age<25 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE NONEMPLOYED, AGES 25-54;
*********************************;

local sample = " if sex==1 & age>=25 & age<55 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE NONEMPLOYED, AGES 55-64;
*********************************;

local sample = " if sex==1 & age>=55 & age<65 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE EMPLOYED, AGES 18-24;
*********************************;

local sample = " if sex==1 & age>=18 & age<25 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE EMPLOYED, AGES 25-54;
*********************************;

local sample = " if sex==1 & age>=25 & age<55 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE EMPLOYED, AGES 55-64;
*********************************;

local sample = " if sex==1 & age>=55 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

/*


*FEMALE EMPLOYED, AGES 18-64;
*********************************;

local sample = " if sex==2 & age>=18 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED & MARRIED, AGES 18-64;
*********************************;

local sample = " if sex==2 & civstat==1 & age>=18 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED & EVER MARRIED, AGES 18-64;
*********************************;

local sample = " if sex==2 & civstat~=4 & age>=18 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*FEMALE EMPLOYED & SINGLE, AGES 18-64;
*********************************;

local sample = " if sex==2 & civstat==4 & age>=18 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*FEMALE ALL, AGES 18-64;
*********************************;

local sample = " if sex==2 & age>=18 & age<65 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*MALE EMPLOYED, AGES 18-64;
*********************************;

local sample = " if sex==1 & age>=18 & age<65 & (empstat==1 | empstat==2)";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*MALE NONEMPLOYED, AGES 18-64;
*********************************;

local sample = " if sex==1 & age>=18 & age<65 & empstat==3";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*MALE ALL, AGES 18-64;
*********************************;

local sample = " if sex==1 & age>=18 & age<65 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*ALL, AGES 18-64;
*********************************;

local sample = " if age>=18 & age<65 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*FEMALE NON-EMPLOYED, AGES 65+;
*********************************;

local sample = " if sex==2 & age>=65 & empstat==3 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*FEMALE EMPLOYED, AGES 65+;
*********************************;

local sample = " if sex==2 & age>=65 & (empstat==1 | empstat==2) ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*MALE NON-EMPLOYED, AGES 65+;
*********************************;

local sample = " if sex==1 & age>=65 & empstat==3 ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};


*MALE EMPLOYED, AGES 65+;
*********************************;

local sample = " if sex==1 & age>=65 & (empstat==1 | empstat==2) ";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*Males, AGES 65+;
*********************************;

local sample = " if age>=65 & sex==1";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*Females, AGES 65+;
*********************************;

local sample = " if age>=65 & sex==2";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*ALL AGES 65+;
*********************************;

local sample = " if age>=65";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

*Children, ages 15-17;
*********************************;

local sample = " if age>=15 & age<=17";
local i = 1;
foreach var of varlist `variables' {;
	reg `var' `dataset' [aw=recwght] `sample', noc;
	};

summ homeprod0 [aw=recwght] if age>=18 & age<65 & sex==2 & under18==0
  & empstat==3 & dataset==1965;

summ homeprod0 [aw=recwght] if age>=18 & age<65 & sex==2 & under18==0
  & empstat==3 & dataset==1975;

summ homeprod0 [aw=recwght] if age>=18 & age<65 & sex==2 & under18==0
  & (empstat==1 | empstat==2) & dataset==1965;

summ homeprod0 [aw=recwght] if age>=18 & age<65 & sex==2 & under18==0
  & (empstat==1 | empstat==2) & dataset==1975;

*/
/*
gen college = (educ==5 | educ==6);
gen hsdp = (educ==1 | educ==2);
gen hscl = (educ==3 | educ==4);


reg homeprod1 work_core hscl college [aw=recwght] if sex==1 & age>=18 & age<65 & dataset==1965;

*/
log close;
